/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.rcs.inconn.InboundConfigData;
import com.ibm.hwmca.fw.rcs.inconn.InboundConfigManager;
import com.ibm.hwmca.fw.rcs.path.InvalidStateException;
import com.ibm.hwmca.fw.rcs.path.PathCancelledException;
import com.ibm.hwmca.fw.rcs.path.PathFailedException;
import com.ibm.hwmca.fw.rcs.path.PathState;
import com.ibm.hwmca.fw.rcs.path.RcsPath;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;

public class RcsCallbackSegmentThread
extends Thread {
    private static final String TRACE_MASKT = "XRCSCSTT";
    private static final String TRACE_MASKF = "XRCSCSTF";
    private static final String TRACE_MASKD = "XRCSCSTD";
    private static final String RCS_CONTROL = "rcsControl.pl";
    private static final String RUN_MODEM_ANSWER = "--runmodemanswer";
    private static final String STOP_MODEM_ANSWER = "--stopmodemanswer";
    private static FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-ClBkSqTh");
    private RcsPath sessionPath = null;
    private InboundConfigManager inCfgMgr = null;

    RcsCallbackSegmentThread(RcsPath path) {
        Trace.trace(TRACE_MASKT, "-> RcsCallbackSegmentThread(RcsPath)");
        this.sessionPath = path;
        Trace.trace(TRACE_MASKT, "<- RcsCallbackSegmentThread(RcsPath)");
    }

    RcsCallbackSegmentThread(InboundConfigManager mgr) {
        Trace.trace(TRACE_MASKT, "-> RcsCallbackSegmentThread(InboundConfigManager)");
        this.inCfgMgr = mgr;
        Trace.trace(TRACE_MASKT, "<- RcsCallbackSegmentThread(InboundConfigManager)");
    }

    public void run() {
        Trace.trace(TRACE_MASKT, "-> RcsCallbackSegmentThread.run()");
        if (this.sessionPath != null) {
            this.runPath();
        } else if (this.inCfgMgr != null) {
            this.runTimeThread();
        } else {
            Trace.trace(TRACE_MASKF, "   RcsCallbackSegmentThread.run() - nothing to do");
        }
        Trace.trace(TRACE_MASKT, "<- RcsCallbackSegmentThread.run()");
    }

    private void runTimeThread() {
        Trace.trace(TRACE_MASKT, "-> RcsCallbackSegmentThread.runTimeThread()");
        String command = "rcsControl.pl --runmodemanswer";
        InboundConfigData configData = this.inCfgMgr.getInboundConfig();
        while (true) {
            if (configData.isAllowUnattendedService()) {
                try {
                    RootProcess.executeProgram(command);
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKT, "RcsCallbackSegment.runTimeThread Exception: " + e);
                }
            }
            try {
                Thread.sleep(300000L);
                continue;
            }
            catch (InterruptedException ie) {
                Trace.trace(TRACE_MASKF, "   RcsCallbackSegmentThread.runTimeThread() - Interrupted");
                continue;
            }
            break;
        }
    }

    private void runPath() {
        boolean keepWaiting = true;
        int rc = 0;
        Trace.trace(TRACE_MASKT, "-> RcsCallbackSegmentThread.runPath()");
        while (keepWaiting) {
            keepWaiting = false;
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ie) {
                keepWaiting = true;
                Trace.trace(TRACE_MASKF, "   RcsCallbackSegmentThread.runPath() - Interrupted");
            }
        }
        try {
            rc = RootProcess.executeProgram("rcsControl.pl --stopmodemanswer");
        }
        catch (IOException ioe) {
            Trace.trace(TRACE_MASKT, "<- RcsCallbackSegmentThread.runPath() - couldn't stop modem");
            return;
        }
        try {
            this.sessionPath.open();
            if (this.sessionPath.getPathIdentifier().getState() == PathState.ACTIVE) {
                Trace.trace(TRACE_MASKT, "<- RcsCallbackSegmentThread.runPath() - success");
            } else {
                Trace.trace(TRACE_MASKT, "<- RcsCallbackSegmentThread.runPath() - failed");
                Trace.trace(TRACE_MASKF, this.sessionPath.getPathIdentifier().getState().getDescription().toString());
            }
        }
        catch (InvalidStateException ise) {
            Trace.trace(TRACE_MASKF, "   RcsCallbackSegmentThread.runPath() - InvalidStateException");
        }
        catch (PathCancelledException pce) {
            Trace.trace(TRACE_MASKF, "   RcsCallbackSegmentThread.runPath() - PathCancelledException");
        }
        catch (PathFailedException pfe) {
            Trace.trace(TRACE_MASKF, "   RcsCallbackSegmentThread.runPath() - PathFailedException");
        }
        Trace.trace(TRACE_MASKT, "<- RcsCallbackSegmentThread.runPath()");
    }
}

